#!/bin/bash

#Find the Memory Usage in Percentage
perc=`/usr/bin/free | awk '/Mem/{printf("RAM Usage: %.2f%\n"), $3/$2*100}' |  awk '{print $3}' `

#Making a variable in intiger which is nearest to the actual memory usage.
use=$(/usr/bin/free | awk '/Mem/{printf("RAM Usage: %.2f%\n"), $3/$2*100}' |  awk '{print $3}' | awk -F '.' '{print $1}' )

#Below two lines are just to verify whether the variables are working properly. Comment it after verifying it is working properly.
#echo "$use"
#echo "$perc"


#Comparing memory usage value to generate alerts.
if [ $use -ge 85 ]; then
        echo "Critical !!! Memory usage is high $perc"
    exit 2
elif [ $use -ge 80 -a $use -lt 85 ]; then
        echo "Warning! Memory Usage is $perc"
    exit 1
else
        echo "Memory usage is good $perc"
   exit 0
fi
